<?php $__env->startSection('title'); ?>
<?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('back-content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark"><?php echo e($title); ?></h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">All <?php echo e($title); ?></li>
                </ol>
            </div>
        </div>
    </div>
</div>
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12 col-12">
                <div class="card card-success">
                    <div class="card-header">
                        <h3 class="card-title">All <?php echo e($title); ?></h3>
                    </div>
                    <div class="card-body">
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="10%">User</th>
                                    <th width="15%">Banner</th>
                                    <th>Title</th>
                                    <th>Link</th>
                                    <th width="8%">Post Date</th>
                                    <th width="8%">Exp Date</th>
                                    <th width="8%">Duration</th>
                                    <th width="8%">Cost</th>
                                    <th width="8%">Status</th>
                                    <th width="10%">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key + 1); ?></td>
                                    <td><?php echo e(user_name($data->user_id)); ?><br><small>(<?php echo e(user_code($data->user_id)); ?>)</small></td>
                                    <td><img src="<?php echo e(URL::to($data->image)); ?>" width="120" alt=""></td>
                                    <td><?php echo e($data->title); ?></td>
                                    <td><?php echo e($data->link); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($data->created_at)->format('d/m/Y g:i A')); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($data->exp_date)->format('d/m/Y g:i A')); ?></td>
                                    <td><?php echo e($data->duration); ?> Days</td>
                                    <td><?php echo e($data->cost); ?>$</td>
                                    <td>
                                        <?php if($data->exp_date < date('Y-m-d')): ?>
                                            <span class="badge bg-success">Completed</span>
                                        <?php else: ?>
                                            <?php if($data->approval == 1): ?>
                                                <span class="badge bg-success">Approved</span>
                                            <?php elseif($data->approval == 2): ?>
                                                <span class="badge bg-danger">Reject</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger">Pending</span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($data->approval == 0): ?>
                                        <a href="javascript:;" class="btn btn-success btn-sm" data-toggle="modal" data-target="#edit_<?php echo e($data->id); ?>">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <?php endif; ?>

                                        <a href="javascript:;" class="btn btn-success btn-sm" data-toggle="modal" data-target="#exp_date_edit_<?php echo e($data->id); ?>">
                                            <i class="fas fa-calendar"></i>
                                        </a>

                                        <button type="button" onclick="deleteData(<?php echo e($data->id); ?>)" class="btn btn-danger btn-sm">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                        <form id="delete-form-<?php echo e($data->id); ?>" action="<?php echo e(route('admin.advertisement.delete', $data->id)); ?>" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                        </form>
                                    </td>
                                </tr>
                                <div class="modal fade" id="edit_<?php echo e($data->id); ?>" tabindex="-1" role="dialog" aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <form action="<?php echo e(route('admin.advertisement.update', $data->id)); ?>" method="POST" enctype="multipart/form-data">
                                            <?php echo csrf_field(); ?>
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Approval Status Change</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="form-group col-lg-12 col-md-12 col-12">
                                                    <label for="status">Status</label>
                                                    <select class="form-control" name="approval" id="approval">
                                                        <option value="1" <?php if($data->approval == 1): ?> selected <?php endif; ?>>Approved</option>
                                                        <option value="0" <?php if($data->approval == 0): ?> selected <?php endif; ?>>Pending</option>
                                                        <option value="2" <?php if($data->approval == 2): ?> selected <?php endif; ?>>Reject</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-lg-12 col-md-12 col-12">
                                                    <label for="reason">Reason</label>
                                                    <textarea class="form-control" name="reason" id="reason" cols="30" rows="3"><?php echo e($data->reason); ?></textarea>
                                                </div>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <div class="modal fade" id="exp_date_edit_<?php echo e($data->id); ?>" tabindex="-1" role="dialog" aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <form action="<?php echo e(route('admin.advertisement-exp-dade.update', $data->id)); ?>" method="POST" enctype="multipart/form-data">
                                            <?php echo csrf_field(); ?>
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Update Expire Date</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body row">
                                                    <div class="form-group col-lg-12 col-md-12 col-12">
                                                        <label for="sxp_date">Expire Date</label>
                                                        <input type="date" class="form-control" name="exp_date" value="<?php echo e($data->exp_date); ?>">
                                                    </div>
                                                </div>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>

<script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

<script>
    $(function() {
        $("#example1").DataTable({
            "responsive": true
            ,"autoWidth": false
            ,"pageLength": 100
        , });
        $('#example2').DataTable({
            "paging": true
            , "lengthChange": false
            , "searching": false
            , "ordering": true
            , "info": true
            , "autoWidth": false
            , "responsive": true
        });
    });

    function deleteData(id) {
        if (confirm("Are you sure?")) {
            document.getElementById('delete-form-' + id).submit();
        }
        return false;
    }

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealruom/microjob.dealingwork.com/resources/views/backend/pages/system-setting/advertisement.blade.php ENDPATH**/ ?>